// ======== ======== ======== ======== ======== ======== ======== ========
//
//	title : classMake[ m_light.cpp ]		Auter : KENSUKE WATANABE
//													Data  : 2017/04/27
//
// -------- -------- -------- -------- -------- -------- -------- --------
//Update : 2017/04/27
//
// ======== ======== ======== ======== ======== ======== ======== ========
// -------- -------- -------- -------- -------- -------- -------- --------
// CN[ht@C
// -------- -------- -------- -------- -------- -------- -------- --------
#include "main.h"
#include "light.h"
#include "renderer.h"

// ======== ======== ======== ======== ======== ======== ======== ========
// 
// -------- -------- -------- -------- -------- -------- -------- --------
CLight::CLight()
{
	for (int n = 0; n < MAX_LIGHT; n++)
	{
		m_light[n].Position = D3DXVECTOR3(0.f, 0.f, 0.f);
		m_light[n].Diffuse = D3DXCOLOR(1.f, 1.f, 1.f, 1.f);
		m_light[n].Ambient = D3DXCOLOR(2.f, 2.f, 2.f, 0.5f);
	}
}

// ======== ======== ======== ======== ======== ======== ======== ========
// 
// -------- -------- -------- -------- -------- -------- -------- --------
void CLight::Init(void)
{
	// foCX̎擾
	LPDIRECT3DDEVICE9 pDevice = CRenderer::GetDevice();

	for (int n = 0; n < MAX_LIGHT; n++)
	{
		ZeroMemory(&m_light, sizeof(D3DLIGHT9));	// 
		m_light[n].Type = D3DLIGHT_DIRECTIONAL;		// ^Cv

		if (n == 0)
		{
			m_light[n].Position.x = 1.f;
			m_light[n].Position.y = 1.f;
			m_light[n].Position.z = 1.f;
			m_light[n].Diffuse = D3DXCOLOR(1.f, 1.f, 1.f, 1.f);	// fBNViCg(s)̐F
			m_light[n].Ambient = D3DXCOLOR(0.2f, 0.2f, 0.2f, 1.f);	// ArGgCg()̐F
			m_light[n].Specular = D3DXCOLOR(1.f, 1.f, 1.f, 1.f);
		}

		D3DXVECTOR3 vecDir(0.f - m_light[n].Position.x, 0.f - m_light[n].Position.y, 0.f - m_light[n].Position.z);	// fBNViCǧ
		D3DXVec3Normalize((D3DXVECTOR3*)&m_light[n].Direction, &vecDir);	// px͂̂܂܂ɂāAPʃxNgɒ𒼂

		pDevice->SetLight(n, &m_light[n]);					// CfbNXnԂɃCgZbg
		pDevice->LightEnable(n, TRUE);						// CfbNXnԂ̃Cg̃XCb`
	}

	pDevice->SetRenderState(D3DRS_LIGHTING, TRUE);			// Cg̕\Lɂ
}

D3DXVECTOR3 CLight::GetPos(int n)
{
	assert(n > 0 || n < MAX_LIGHT && "̒ls");
	return (D3DXVECTOR3)m_light[n].Position;
}

D3DXVECTOR3 CLight::GetVecAtZERO(int n)
{
	assert(n > 0 || n < MAX_LIGHT && "̒ls");

	D3DXVECTOR3 lightNom;
	D3DXVECTOR3 pos = GetPos(0);
	D3DXVec3Normalize(&lightNom, &pos);
	lightNom.y *= -1;

	return lightNom;
}

D3DXVECTOR3 CLight::GetDir(int n)
{
	assert(n > 0 || n < MAX_LIGHT && "̒ls");
	return (D3DXVECTOR3)m_light[n].Direction;
}